<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
	require_once("Mail/RFC822.php"); 
	
	function normalize_address_string($address){
		$normalized = '';
		
		$address = str_replace_outside_quotes(";",",",$address); //parseAddressList requires comma separated addresses
		$parse_array = Mail_RFC822::parseAddressList($address);
		$address_arr = array();
		//add unique addresses to the address array for validating
		foreach ($parse_array as $parse){
			$to_var = $parse->mailbox.'@'.strtolower($parse->host);
			if (!in_array($to_var, $address_arr)){
				array_push($address_arr, $to_var);
				$normalized .= $to_var.',';
			}
		}
		
		$normalized = rtrim($normalized, ",");
		
		return $normalized;
	}
	
	function normalize_address($address, &$mail_arr, &$address_arr){
		$address = str_replace_outside_quotes(";",",",$address); //parseAddressList requires comma separated addresses
		$parse_array = Mail_RFC822::parseAddressList($address);
		//add unique addresses to the address array for validating and mail array for sending
		if(is_array($parse_array)){
			foreach ($parse_array as $parse){
				$mail_var = $parse->mailbox.'@'.$parse->host;
				if (!in_array($mail_var, $address_arr)){
					array_push($address_arr, $mail_var);
				}
				if (!in_array($mail_var, $mail_arr)){
					array_push($mail_arr, $mail_var);
				}
			}
		}
	}
	
	function str_replace_outside_quotes($replace,$with,$string){
		$result = "";
		$outside = preg_split('/("[^"]*"|\'[^\']*\')/',$string,-1,PREG_SPLIT_DELIM_CAPTURE);
		while ($outside)
			$result .= str_replace($replace,$with,array_shift($outside)).array_shift($outside);
		return $result;
	}